create or replace package tbicds.PCK_SYSTEM_ID
AUTHID CURRENT_USER 
is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  --id type prefixes 
  c_vPatient    varchar2(3) := 'PAT';
  c_vProvider   varchar2(3) := 'PRO';
  c_vContact    varchar2(3) := 'CON';
  c_vEncounter  varchar2(3) := 'ENC';
  c_vProblem    varchar2(4) := 'PROB';
  c_vProbObserv varchar2(4) := 'OBSV';
  c_vLab        varchar2(4) := 'LAB';
  c_vLabResult  varchar2(4) := 'LRES';
  c_vCDA        varchar2(4) := 'CDA';

  c_vVS             varchar2(4) := 'VITS';
  c_vVSOrganizer    varchar2(6) := 'VSORG';
  c_vVSObservation  varchar2(6) := 'VSOBSV';
  c_vVSObsComponent varchar2(7) := 'VSOCOMP';
  c_vPatSource      varchar2(6) := 'PATSRC';

  function GetNewPersonID return varchar2;

  function GetNewPatientID(pi_vFirstName   in varchar2,
                           pi_vLastName    in varchar2,
                           pi_vDateOfBirth in varchar2,
                           pi_vGender      in varchar2,
                           pi_vSSN         in varchar2) return varchar2;

  function GetNewProviderID(pi_vFirstName   in varchar2,
                            pi_vLastName    in varchar2) return varchar2;

  function GetNewProviderID(pi_vFirstName in varchar2,
                            pi_vLastName  in varchar2,
                            pi_vNPI       in varchar2) return varchar2;

  function GetNewContactPatientID(pi_vPatientID in varchar2) return varchar2;

  function FromStringToNumber(pi_vString in varchar2, pi_nLength in number)
    return varchar2;

  function FromNumberToString(pi_vNumber in varchar2) return varchar2;

  function GenerateRandomString(pi_nLength in number) return varchar2;

  function GetDateTimeString return varchar2;

end;
/

